library(dtw)
library(ggplot2)


setwd("D:/work/Types_of_solutions/few different")

files_few <- list("1","2")
for (i in 1:40){
  if (i==1){
    for (j in 1:10){
      s <- paste("2+",j,"(exp(t))^(-1)",sep = "")
      files_few[[length(files_few)+1]] = s
    }
  }
  if (i==2){
    for (j in 1:10){
      s <- paste("2-",j,"(exp(t))^(-1)",sep = "")
      files_few[[length(files_few)+1]] = s
    }
  }
  if (i==3){
    for (j in 1:10){
      s <- paste("exp((t-10) del 100)sin(",j,"t)",sep = "")
      files_few[[length(files_few)+1]] = s    }
  }
  if (i==4){
    for (j in 1:10){
      s <- paste("exp(t del(",j,"+5))",sep = "")
      files_few[[length(files_few)+1]] = s    }
  }
  if (i==5){
    for (j in 1:10){
      s <- paste("exp(t) del (20+exp(t) del ",j,")",sep = "")
      files_few[[length(files_few)+1]] = s    }
  }
  if (i==6){
    for (j in 1:10){
      s <- paste("exp(t)^(-1)sin(",j,"t)",sep = "")
      files_few[[length(files_few)+1]] = s    }
  }
  if (i==7){
    for (j in 1:10){
      s <- paste("sin(",j,"t)",sep = "")
      files_few[[length(files_few)+1]] = s    }
  }
  if (i==8){
    for (j in 1:10){
      s <- paste("sin(t del ",j,")",sep = "")
      files_few[[length(files_few)+1]] = s    }
  }
  # if (i==9){
  #   for (j in 1:10){
  #     s <- paste("t del ",j,sep = "")
  #     files_few[[length(files_few)+1]] = s    }
  # }
}


len_few <- length(files_few)

types_of_sol_few <- matrix(data=NA,nrow=len_few,ncol=1000)
types_of_sol_few <- data.frame(types_of_sol_few)


rownames(types_of_sol_few) <- files_few
num=0
for (i in 1:len_few){
  num <- num+1
  s <- paste(files_few[i],".tsv",sep = "")
  #print(s)
  mydata <- read.csv(s,header = FALSE, sep = "\t")
  mydata <- as.numeric(mydata)
  types_of_sol_few[num,]<- mydata
  types_of_sol_few[num,] <- as.numeric(types_of_sol_few[num,])
}


#цcenter data
centre_types_of_sol_few <- t(apply(types_of_sol_few,1, function (x) scale(x, scale= FALSE )))
rownames(centre_types_of_sol_few) <- files_few


M_alig_few <- matrix(data=NA,nrow=len_few,ncol=len_few)
M_alig_few <- data.frame(M_alig_few)
for (i in 1:len_few){
  for(j in i:len_few){
    print(paste("i = ",i,",j =", j))
    #print(j)
    alignment <- dtw(as.numeric(centre_types_of_sol_few[i,]),as.numeric(centre_types_of_sol_few[j,]),keep=TRUE)
    M_alig_few[i,j]=alignment$normalizedDistance
  }
}

M_alig_few[is.na(M_alig_few)] <- 0
M_alig_few_full <-  t(M_alig_few) + M_alig_few 

library(ape)
w_few <- pcoa(D=M_alig_few_full)
coord_pcoa_few <- w_few$vectors[,1:2]
positive_eig_few <- list()
for (i in 1:length(w_few$values$Eigenvalues)){
  if (w_few$values$Eigenvalues[i]>0){
    positive_eig_few[[length(positive_eig_few)+1]] = w_few$values$Eigenvalues[i]
  }
}

positive_eig <- array(unlist(positive_eig_few))
pcoa_relative_eig_few <- round(positive_eig/sum(positive_eig)*100, 5)

rownames(coord_pcoa_few) <- rownames(centre_types_of_sol_few)

type_few <- list()
for (i in 1:2){
  type_few[[i]] = "Steady states"
}
for (i in 3:12){
  type_few[[i]] = "Descending to the steady state"
}
for (i in 13:22){
  type_few[[i]] = "Ascending to the steady state"
}
for (i in 23:32){
  type_few[[i]] = "Divergent oscillations"
}
for (i in 33:42){
  type_few[[i]] = "Increasing exponents"
}
for (i in 43:52){
  type_few[[i]] = "S-shaped curves"
}
for (i in 53:62){
  type_few[[i]] = "Damped oscillations"
}
for (i in 63:72){
  type_few[[i]] = "High-frequency oscillations"
}
for (i in 73:82){
  type_few[[i]] = "Low-frequency oscillations"
}
#for (i in 83:92){
#  type_few[[i]] = "linear function"
#}

#coarse-grained
type_few_rude <- vector(mode='list', length= len_few)
for (i in 1:22){
  type_few_rude[[i]] = "Steady states"
}
for (i in 23:32){
  type_few_rude[[i]] = "Oscillations"
}
for (i in 33:42){
  type_few_rude[[i]] = "Exponents"
}
for (i in 43:52){
  type_few_rude[[i]] = "S-shaped curves"
}
for (i in 53:82){
  type_few_rude[[i]] = "Oscillations"
}
#for (i in 83:92){
#  type_few_rude[[i]] = "linear functions"
#}

type_few <- unlist(type_few, use.names=FALSE)
icons_few <- c(1:len_few)
icons_few<- unlist(type_few_rude, use.names=FALSE)

coord_pcoa_few_data <- data.frame(Sample=factor(rownames(coord_pcoa_few)),
                                  X=coord_pcoa_few[,1],
                                  Y=coord_pcoa_few[,2],
                                  type_few=factor(type_few),
                                  icons_few=factor(icons_few)
)


ggplot(data=coord_pcoa_few_data,aes(x=X, y=Y,group = Sample,shape=icons_few,colour=type_few)) +
  geom_point()+
  theme_light()  +
  xlab(paste("PCoA1 - ",round(pcoa_relative_eig_few[1],2), "%", sep="")) +
  ylab(paste("PCoA2 - ", round(pcoa_relative_eig_few[2],2), "%", sep="")) +
  ggtitle("PCoA plot few types using dtw-distance for types of solutions")+ 
  scale_fill_discrete()


#another pattern (_step)
M_alig_few_step <- matrix(data=NA,nrow=len_few,ncol=len_few)
M_alig_few_step <- data.frame(M_alig_few_step)
for (i in 1:len_few){
  for(j in i:len_few){
    print(paste("i = ",i,",j =", j))
    #print(j)
    alignment <- dtw(as.numeric(centre_types_of_sol_few[i,]),as.numeric(centre_types_of_sol_few[j,]),step.pattern = rabinerJuangStepPattern(4,'c',TRUE))
    #M_alig_few_step[i,j]=alignment$distance
    M_alig_few_step[i,j]=alignment$normalizedDistance
  }
}

M_alig_few_step[is.na(M_alig_few_step)] <- 0
M_alig_few_full_step <-  t(M_alig_few_step) + M_alig_few_step

library(ape)
w_few_step <- pcoa(D=M_alig_few_full_step)
coord_pcoa_few_step <- w_few_step$vectors[,1:2]

positive_eig_few_step <- list()
for (i in 1:length(w_few_step$values$Eigenvalues)){
  if (w_few_step$values$Eigenvalues[i]>0){
    positive_eig_few_step[[length(positive_eig_few_step)+1]] = w_few_step$values$Eigenvalues[i]
  }
}

positive_eig_few_step <- array(unlist(positive_eig_few_step))
pcoa_relative_eig_few_step <- round(positive_eig_few_step/sum(positive_eig_few_step)*100, 5)

rownames(coord_pcoa_few_step) <- rownames(centre_types_of_sol_few)

coord_pcoa_few_data_step <- data.frame(Sample=factor(rownames(coord_pcoa_few_step)),
                                       X=coord_pcoa_few_step[,1],
                                       Y=coord_pcoa_few_step[,2],
                                       type_few=factor(type_few),
                                       icons_few=factor(icons_few)
)


ggplot(data=coord_pcoa_few_data_step,aes(x=X, y=Y,group = Sample,shape=icons_few,colour=type_few)) +
  geom_point()+
  theme_light()  +
  xlab(paste("PCoA1 - ",round(pcoa_relative_eig_few_step[1],2), "%", sep="")) +
  ylab(paste("PCoA2 - ", round(pcoa_relative_eig_few_step[2],2), "%", sep="")) +
  ggtitle("PCoA plot few types using dtw-distance (step.patterns = rabinerJuangStepPattern(4,'c',TRUE)) for types of solutions")+ 
  scale_fill_discrete()

